unit mLoeser;

interface
uses mAusgabe, sysUtils;
const max = 20;
type TSpiel = class
    private
      Feld : array [0..max, 0..max] of boolean;
      kAusgabe : TfrmAusgabe;
      zAnzahl:integer;
      procedure setzeDameInSpalte (anz, spalte : integer);
      function DameBedroht (anz, spalte, zeile : integer):boolean;
      procedure ausgeben(anz : integer);
    public
      procedure Loese (anz : integer);
      constructor Create(pAusgabe :TfrmAusgabe);
end;

implementation
  constructor TSpiel.Create(pAusgabe :TfrmAusgabe);
  begin
    kAusgabe := pAusgabe;
  end;

  procedure TSpiel.Loese(anz:integer);
  var zeile, spalte : integer;
  begin
    if anz <= max then begin
      for zeile := 1 to anz do
        for spalte := 0 to anz do
           Feld [zeile, spalte] := false;
      zAnzahl := 0;
      setzeDameInSpalte (anz, 1);
    end;
  end;

  procedure TSpiel.setzeDameInSpalte (anz, spalte : integer);
  var zeile : integer;
  begin
    if spalte > anz then begin
       zAnzahl := zAnzahl + 1;
       ausgeben (anz);
       end;
    for zeile := 1 to anz do
       if not DameBedroht (anz,spalte, zeile)
       then begin
          Feld[Zeile,Spalte] := true; Feld[Zeile,0] := true;  //Setzen
            setzeDameInSpalte (anz, spalte + 1);               // rek. Aufruf
          Feld[Zeile,Spalte] := false; Feld[Zeile,0] := false;//Ruecksetzen
       end;

  end;

  function TSpiel.DameBedroht (anz,spalte, zeile : integer):boolean;
  var i, j : integer; bedroht : boolean;
  begin
    bedroht := Feld[zeile, 0];        //Dame in der Zeile

    i := zeile - 1; j := spalte-1;    //Diagonale links oben
    while (i>0) and (j>0) and not bedroht do begin
       bedroht := Feld[i, j];  i:=i-1; j:=j-1; end;

    i := zeile + 1; j := spalte-1;    //Diagonale links oben
    while (i<=anz) and (j>0) and not bedroht do begin
       bedroht := Feld[i, j];   i:=i+1; j:=j-1; end;

    DameBedroht := bedroht;
  end;

  procedure TSpiel.ausgeben(anz : integer);
  var i, j : integer; z : string;
  begin
    kAusgabe.ZeileAusgeben('Lsung  '+ intToStr(zAnzahl));
    for i := 1 to anz do begin
      z := '|';
      for j := 1 to anz do
        if Feld[i,j]
        then z := z + ' x |'
        else z := z + '   |';
      kAusgabe.ZeileAusgeben(z);
    end;
    kAusgabe.ZeileAusgeben(' ');
  end;
end.
